/**
 *  license JS
 *
 *  @description: Used to activate / deactivate licenses via AJAX
 *
 *  @author: Devin Walker
 */

var gpr_ajax_object;

jQuery(document).ready(function ($) {

    //Variables
    var doing_license_registration_ajax = false;
    var admin_url = ajaxurl.replace('/admin-ajax.php', '');
    var spinner_url = admin_url + '/images/spinner';

    //Retina spinner?
    if (window.devicePixelRatio >= 2) {
        spinner_url += '-2x';
    }
    spinner_url += '.gif';

    /**
     * Activates license
     */
    $('.activate-license-btn').on('click', function (e) {

        //prevent default form option
        e.preventDefault();

        if (doing_license_registration_ajax) {
            return false;
        }

        var license_key = $.trim($('.license-input').val());

        if (license_key == '') {
            display_license_message(gpr_ajax_object.i18n.no_license, 'alert-danger');
            return false;
        }

        //empty any messages that may be present
        $('.license-status').fadeOut('300', function () {
            $(this).attr('class', 'license-status');
        });

        doing_license_registration_ajax = true;

        $('.button-secondary').after('<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />');

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            dataType: 'JSON',
            cache: false,
            data: {
                action: 'wordimpress_activate_license',
                license_key: license_key,
                edd_license_activate: true
            },
            error: function (jqXHR, textStatus, errorThrown) {

                //for debugging errors in console
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);

                doing_license_registration_ajax = false;
                $('.register-license-ajax-spinner').remove();
                display_license_message(gpr_ajax_object.i18n.activation_error, 'alert-red');
            },
            success: function (data) {

                //show data in console
                console.log(data);

                //cleanup
                doing_license_registration_ajax = false;
                //remove AJAX loader
                $('.register-license-ajax-spinner').remove();

                //error in activation?
                if (typeof data.error !== 'undefined') {
                    //display error message
                    display_license_error_message(data.error, data.code);
                }

                //No errors, proceed
                else {
                    //@TODO: Check if license is actually active prior to displaying success message
                    //success message
                    display_license_message('Your license has been activated: ' + data.message + '. You will now receive plugin updates.', 'alert-success');
                    //swap buttons
                    $('.register-license').fadeOut().addClass('license-hidden');
                    $('.deactivate-license').removeClass('license-hidden').fadeIn();
                    //add checkmark
                    $('.license-input').addClass('input-active-license');
                    //Update license key to password field
                    $('.license-key').attr('type', 'password');

                }
            }
        });

        return false;
    });


    /**
     * Deactivate a license
     */
    $('.deactivate-license').on('click', function () {

        //prevents overlap
        if (doing_license_registration_ajax) {
            return false;
        }

        //get current license values in inputs
        var license_key = $.trim($('.license-input').val());

        //check if license key is blank
        if (license_key == '') {
            display_license_message('', 'alert-danger');
            return false;
        }

        //empty any messages that may be present
        $('.license-status').fadeOut('300', function () {
            $(this).attr('class', 'license-status');
        });

        //we are starting to do some ajax
        doing_license_registration_ajax = true;

        //place a loading image next to button
        $('.license-button-wrap > .button:visible').after('<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />');

        //start AJAX
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            dataType: 'JSON',
            cache: false,
            data: {
                action: 'wordimpress_deactivate_license',
                license_key: license_key,
                license_email: license_email
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);

                doing_license_registration_ajax = false;
                $('.register-license-ajax-spinner').remove();
                $('.license-status').addClass('alert alert-red').html(gpr_ajax_object.i18n.deactivation_error);
            },
            success: function (data) {

                //debug info shown in console
                console.log(data);

                //no longer doing AJAX
                doing_license_registration_ajax = false;

                //remove spinner
                $('.register-license-ajax-spinner').remove();

                //output errors if any
                if (typeof data.errors !== 'undefined') {
                    var msg = '';
                    for (var key in data.errors) {
                        msg += data.errors[key];
                    }
                    $('.license-status').html(msg);
                } else {

                    //display success message
                    display_license_message(gpr_ajax_object.i18n.deactivation_success, 'alert-warning');
                    //swap buttons
                    $('.deactivate-license').fadeOut().addClass('license-hidden');
                    $('.register-license').removeClass('license-hidden').fadeIn();
                    //clear values
                    $('.license-key').val('').attr('type', 'text');
                    $('.license-email').val('');
                    $('.license-input').removeClass('input-active-license');


                }
            }
        });

        return false;
    });


    /**
     * Check License
     *
     * @param license_key
     * @param license_email
     */
    function check_license(license_key, license_email) {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                action: 'wordimpress_check_license',
                license_key: license_key,
                license_email: license_email
            },
            error: function (jqXHR, textStatus, errorThrown) {
                alert('A problem occurred when trying to check the license, please try again.');
            },
            success: function (data) {
                if (typeof data.errors !== 'undefined') {
                    var msg = '';
                    for (var key in data.errors) {
                        msg += data.errors[key];
                    }
                    $('.support-content').empty().html(msg);
                }
                else {
                    $('.support-content').empty().html(data.message);
                }
            }
        });
    }


});


/**
 * Display License Message
 *
 * @param message
 * @param style
 */
function display_license_message(message, style) {

    var license_status = jQuery('.license-status');

    license_status.html(message).attr('class', '').addClass('license-status alert ' + style);
    license_status.fadeIn();

}

/**
 * Display License Error Message
 *
 * @param message
 * @param code
 */
function display_license_error_message(message, code) {

    var output_message = '';
    var license_status = jQuery('.license-status');

    switch (code) {
        case '100':
            output_message = message + ': Please check that you have entered the license key and email address found in your completed order email.';
            break;
        case '101':
            output_message = message;
            break;
        default :
            output_message = message + '; Please contact support for assistance with activating your license.'
    }


    license_status.html(output_message).attr('class', '').addClass('license-status alert alert-red');
    license_status.fadeIn();


}